// FileIOShell.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"
#include "FileIOShell.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

// Global Structure for storing command line arguments
typedef struct tCommandLineArgs
{
  CString sInFileName  ;
  CString sOutFileName ;
  CString sInCMDFileName ;
  int     nMaxFileSize ;
  char    cData[MAXFILESIZE] ;
  long	  nBlockAddr[MAXBLOCKNUM];
  int	nBlockCount;
} sCommandLineArgs ;

void InitializeCommandLineArgs(sCommandLineArgs *sContext) ;
BOOL ParseCommandLine(int argc, TCHAR* argv[], sCommandLineArgs *sContext) ;

// The one and only application object

CWinApp theApp;

using namespace std;

int _tmain(int argc, TCHAR* argv[], TCHAR* envp[])
{
	int nRetCode = 0;
	sCommandLineArgs sContext ;

	// initialize MFC and print and error on failure
	if (!AfxWinInit(::GetModuleHandle(NULL), NULL, ::GetCommandLine(), 0))
	{
		// TODO: change error code to suit your needs
		_tprintf(_T("Fatal Error: MFC initialization failed\n"));
		nRetCode = 1;
	}
	else
	{
		// TODO: code your application's behavior here.
		// Initialize Command Line Argument structure
		InitializeCommandLineArgs(&sContext) ;

		// Parse the command line arguments
		if (ParseCommandLine(argc, argv, &sContext) == FALSE)
          return nRetCode ;

		// Read an ASCII text file into an array to be manipulated
		bReadFileToArray2(sContext.sInFileName, &sContext.nMaxFileSize, &sContext.cData[0]) ;
//		bReadFileToArray(sContext.sInCMDFileName, &sContext.nMaxFileSize, &sContext.cData[0]) ;

		HEXtoBinary(&sContext.nMaxFileSize, &sContext.cData[0]);
//		SwapEndian(&sContext.nMaxFileSize, &sContext.cData[0]);

//		MotHEXtoBinary(&sContext.nMaxFileSize, &sContext.cData[0]);
//		IntelHEXtoBinary(&sContext.nMaxFileSize, &sContext.cData[0]);
//		BuildBlockAddrArray(&sContext.nMaxFileSize, &sContext.cData[0], &sContext.nBlockAddr[0], &sContext.nBlockCount);
//		SortBlockAddrArray(&sContext.nBlockAddr[0], &sContext.nBlockCount);
//		SortBlockDataRecords(&sContext.nMaxFileSize, &sContext.cData[0], &sContext.nBlockAddr[0], &sContext.nBlockCount);
//		RemoveExtraInfo(&sContext.nMaxFileSize, &sContext.cData[0], &sContext.nBlockAddr[0], &sContext.nBlockCount);
				
		bWriteArrayToFile(sContext.sOutFileName, &sContext.nMaxFileSize, &sContext.cData[0]) ;

	}

	return nRetCode;
}


/* **********************************************************************
// Subroutines used for supporting the main function.  These routines are
// used to initialize the structure that holds the Command Line Arguments.
// There is additional support for Parsing the Command Line Arguments.
// **********************************************************************
*/
void InitializeCommandLineArgs(sCommandLineArgs *sContext)
{
  int i ;
//  (*sContext).sInFileName   = "C:\\Projects\\FileIOShell\\Debug\\IPM.hex" ;
//  (*sContext).sOutFileName  = "C:\\Projects\\FileIOShell\\Debug\\IPM_out.hex" ;
//  (*sContext).sOutInfoFileName  = "C:\\Projects\\FileIOShell\\Debug\\IPM_Info_out.hex" ;

// (*sContext).sInFileName   = "C:\\Projects\\FileIOShell\\Debug\\Example_281xFlash_sci8.hex" ;
//  (*sContext).sOutFileName  = "C:\\Projects\\FileIOShell\\Debug\\Example_281xFlash_sci8_out.hex" ;

 //*** (*sContext).sInCMDFileName   = "C:\\_working laptop\\_App-reports in development\\Boot-SCIA FLASH Programming\\code\\AppCode\\Debug\\AppCode_binCMD.txt" ;
//  (*sContext).sInFileName   = "C:\\_working laptop\\_App-reports in development\\Boot-SCIA FLASH Programming\\code\\AppCode\\Debug\\Example_281xFlash_sci8.hex" ;
 //*** (*sContext).sOutFileName  = "C:\\_working laptop\\_App-reports in development\\Boot-SCIA FLASH Programming\\code\\AppCode\\Debug\\AppCode.bin" ;

//	(*sContext).sInCMDFileName   = "C:\\code\\AppCode\\Debug\\AppCode_binCMD.txt" ;
//	(*sContext).sOutFileName  = "C:\\code\\AppCode\\Debug\\AppCode.bin" ;

//  (*sContext).sInCMDFileName   = "C:\\Projects\\FileIOShell\\code\\AppCode\\Debug\\AppCode_binCMD.txt" ;
//  (*sContext).sOutFileName  = "C:\\Projects\\FileIOShell\\code\\AppCode\\Debug\\AppCode.bin" ;


  


  (*sContext).nMaxFileSize  = MAXFILESIZE ;
  
  for (i=0; i < MAXFILESIZE; i++)
  {
    (*sContext).cData[i] = 0x00 ;
  }
}

BOOL ParseCommandLine(int argc, TCHAR* argv[], sCommandLineArgs *sContext)
{
  int i ;
  // Parse command-line switches  
  for (i=0; i<argc; i++)
  {
    if (strcmp(argv[i],"-i") == 0)
    {
      (*sContext).sInFileName = argv[i+1] ;

//debugging 7/13
      printf("\n") ;
      printf("Input filename = %s\n",(*sContext).sInFileName) ;



      i++ ;
    }
    else if (strcmp(argv[i],"-o") == 0)
    {
      (*sContext).sOutFileName = argv[i+1] ;
      i++ ;
//debugging 7/13
      printf("\n") ;
      printf("Output filename = %s\n",(*sContext).sOutFileName) ;

    }
    else if (strcmp(argv[i],"-help") == 0)
    {
      printf("\n") ;
      printf("FileIOShell [OPTIONS]\n") ;
      printf("  -i <input file name>\n") ;
	  printf("               : Input file name\n") ;
      printf("  -o <output file name>\n") ;
	  printf("               : Output file name\n") ;
      printf("  -help        : This message\n") ;
      printf("\n") ;
	  return FALSE ;
    }
  }
  return TRUE ;
}